% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/largest_common_cc.R
\name{largest_common_cc}
\alias{largest_common_cc}
\title{Find the largest common connected subgraph(LCCS)}
\usage{
largest_common_cc(A, B, min_degree = 1)
}
\arguments{
\item{A}{A matrix or an 'igraph' object. Adjacency matrix of \eqn{G_1}.}

\item{B}{A matrix or an 'igraph' object. Adjacency matrix of \eqn{G_2}.}

\item{min_degree}{A number. Defines the level of connectness of the obtained largest common
connected subgraph. The induced subgraph is an graph with a minimum degree of vertices equal
to min_degree.}
}
\value{
\code{largest_common_cc} returns the common largest connected subgraphs of
two aligned graphs in the 'igraph' object form and a logical vector indicating which vertices in
the original graphs remain in the induced subgraph.
}
\description{
Assume two aligned graphs, find the largest common connect subgraph of these
two graphs, which is an induced connected subgraph of both graphs that has as many vertices
as possible.
}
\examples{
cgnp_pair <- sample_correlated_gnp_pair(n = 10, corr =  0.7, p =  0.2)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2
# put no constraint on the minimum degree of the common largest conncect subgraph
lccs1 <- largest_common_cc(g1, g2, min_degree = 1)
# induced subgraph
lccs1$g1
lccs1$g2
# label of vertices of the induced subgraph in the original graph
igraph::V(g1)[lccs1$keep]

# obtain a common largest connect subgraph with each vertex having a minimum degree of 3
lccs3 <- largest_common_cc(g1, g2, min_degree = 3)
}
