% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hto.anno.R
\name{hto.anno}
\alias{hto.anno}
\title{Demultiplexing HTOs}
\usage{
hto.anno(hto.data = "data.frame", cov.thr = 10, assignment.thr = 80)
}
\arguments{
\item{hto.data}{HTO raw data}

\item{cov.thr}{A number which avrage coverage is devided by to set a thershold for low coverage, default = 10.}

\item{assignment.thr}{A percent above which you decide to set as a good sample assignment/HTO, default = 80.}
}
\value{
An object of class iCellR
}
\description{
Demultiplexing HTOs
}
\examples{
my.hto <- read.table(file = system.file('extdata', 'dense_umis.tsv',
         package = 'iCellR'),
         as.is = TRUE)
head(my.hto)[1:5]

htos <- hto.anno(hto.data = my.hto)
head(htos)

boxplot(htos$percent.match)

}
