% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_multidata.R
\name{multidata}
\alias{multidata}
\title{Multidata Class}
\usage{
multidata(
  times = integer(0),
  series = integer(0),
  series_esd = integer(0),
  series_names = character(0)
)
}
\arguments{
\item{times}{A numeric vector representing the time points of the time series.}

\item{series}{A numeric vector or matrix representing the main time series.}

\item{series_esd}{A numeric vector or matrix representing the additional series, such as error standard deviations or other related data.}

\item{series_names}{An optional character vector representing the name of the series.}
}
\description{
The `multidata` class is an S7 class designed to represent multidimensional time series models, including the main time series and additional series (e.g., error standard deviations or related variables).
}
\section{Validation Rules}{

- `@times` must be a numeric vector and strictly increasing.
- `@series` must be a numeric matrix or empty. Its number of rows must match the length of `@times`.
- `@series_esd` must be a numeric matrix or empty. If provided and not empty, its dimensions must match those of `@series`.
- If `@series_names` is provided, it must be a character vector of the same length as the number of columns of `@series`, and contain unique values.
}

\examples{
# Create a multidata object
multidata_instance <- multidata(
  times = c(1, 2, 3, 4),
  series = matrix(c(10, 20, 15, 25,
                    12, 18, 17, 23), 
                  nrow = 4, ncol = 2),
  series_esd = matrix(c(1, 1.5, 1.2, 1.8,
                        0.9, 1.3, 1.1, 1.7),
                      nrow = 4, ncol = 2)
)
}
\seealso{
[BiAR]
}
