% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_CiARclass.R
\name{CiAR}
\alias{CiAR}
\title{`CiAR` Class}
\usage{
CiAR(
  times = integer(0),
  series = integer(0),
  series_esd = integer(0),
  fitted_values = integer(0),
  kalmanlik = integer(0),
  coef = integer(0),
  tAhead = 1,
  forecast = integer(0),
  interpolated_values = integer(0),
  interpolated_times = integer(0),
  interpolated_series = integer(0),
  zero_mean = TRUE,
  standardized = TRUE
)
}
\arguments{
\item{times}{A numeric vector representing the time points.}

\item{series}{A complex vector representing the values of the time series.}

\item{series_esd}{A numeric vector representing the error standard deviations of the time series.}

\item{fitted_values}{A numeric vector containing the fitted values from the model.}

\item{kalmanlik}{A numeric value representing the Kalman likelihood of the model.}

\item{coef}{A numeric vector containing the estimated coefficients of the model.}

\item{tAhead}{A numeric value specifying the forecast horizon (default: 1).}

\item{forecast}{A numeric vector containing the forecasted values.}

\item{interpolated_values}{A numeric vector containing the interpolated values.}

\item{interpolated_times}{A numeric vector containing the times of the interpolated data points.}

\item{interpolated_series}{A numeric vector containing the interpolated series.}

\item{zero_mean}{A logical value indicating if the model assumes a zero-mean process (default: TRUE).}

\item{standardized}{A logical value indicating if the model assumes a standardized process (default: TRUE).}
}
\description{
Represents a complex irregular autoregressive (CiAR) time series model.
This class extends the `unidata` class and provides additional properties
for modeling, forecasting, and interpolation of complex-valued time series data.
}
\details{
The `CiAR` class is designed to handle irregularly observed, complex-valued
time series data using an autoregressive approach. It extends the `unidata`
class to include functionalities specific to complex-valued data.

Key features of the `CiAR` class include:
- Support for complex-valued time series data.
- Forecasting and interpolation functionalities for irregular time points.
- Assumptions of zero-mean and standardized processes, configurable by the user.
}
\examples{
o=iAR::utilities()
o<-gentime(o, n=200, distribution = "expmixture", lambda1 = 130, lambda2 = 6.5,p1 = 0.15, p2 = 0.85)
times=o@times
my_CiAR <- CiAR(times = times,coef = c(0.9, 0))

# Access properties
my_CiAR@coef

}
\references{
\insertRef{Elorrieta_2019}{iAR}
}
