% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairingits.R
\name{pairingits}
\alias{pairingits}
\title{Pairing two irregularly observed time series}
\usage{
pairingits(lc1, lc2, tol = 0.1)
}
\arguments{
\item{lc1}{data frame with three columns corresponding to the first irregularly observed time series. The columns must be ordered as follow: First the observational times, second the measures of each time, and third the measurement errors.}

\item{lc2}{data frame with three columns corresponding to the second irregularly observed time series. The columns must be ordered as follow: First the observational times, second the measures of each time, and third the measurement errors.}

\item{tol}{tolerance parameter. Minimum time gap to consider that two observations have measured at different times.}
}
\value{
A list with the following components:
\itemize{
\item{n}{ Number of observations paired by their observational times.}
\item{par}{Data Frame with the paired datasets.}
}
}
\description{
Pairing the observational times of two irregularly observed time series
}
\examples{
data(cvnovag)
data(cvnovar)
pargr=pairingits(cvnovag,cvnovar,tol=0.1)
}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
\seealso{
\code{\link{cvnovag}}, \code{\link{cvnovar}}, \code{\link{BIARkalman}}
}
