% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypr.R
\name{hypr}
\alias{hypr}
\title{Create a hypr object}
\usage{
hypr(..., terms = NULL, order_terms = FALSE)
}
\arguments{
\item{...}{A list of null hypothesis equations}

\item{terms}{(Optional) A list of terms to use. If supplied, matrix rows/columns will be in this order. An error will be thrown if an equation contains a term that is not in this vector.}

\item{order_terms}{(Optional) Whether to order the rows/columns of the hypothesis/contrast matrices alphabetically}
}
\value{
A \code{hypr} object
}
\description{
Use this function to create hypr objects from null hypothesis equations. Each argument should be one equation. For example, a null hypothesis for the grand mean (GM), often used as the intercept, is usually coded as mu~0.
}
\details{
You may call the function without any arguments. In that case, an empty hypr object is returned. This is useful if you want to derive equations from a known hypothesis matrix or contrast matrix.
}
\examples{

# Create an empty hypr object (no hypotheses):
h <- hypr()

# Treatment contrast:
h <- hypr(mu1~0, mu2~mu1, mu3~mu1)

cmat(h, remove_intercept = TRUE)
contr.treatment(3)

# This generates a similar hypr object:
h <- hypr()
cmat(h, add_intercept = TRUE) <- contr.treatment(c("mu1","mu2","mu3"))
h

}
\seealso{
S4 class \code{\link[hypr:hypr-class]{hypr}}
}
