% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Arith.R
\docType{methods}
\name{Arith}
\alias{*,hyperSpec,hyperSpec-method}
\alias{+,hyperSpec,hyperSpec-method}
\alias{-,hyperSpec,hyperSpec-method}
\alias{/,hyperSpec,hyperSpec-method}
\alias{Arith}
\alias{Arith,hyperSpec,hyperSpec-method}
\alias{Arith,hyperSpec,matrix-method}
\alias{Arith,hyperSpec,missing-method}
\alias{Arith,hyperSpec,numeric-method}
\alias{Arith,hyperSpec-method}
\alias{Arith,matrix,hyperSpec-method}
\alias{Arith,numeric,hyperSpec-method}
\alias{\%*\%}
\alias{\%*\%,hyperSpec,hyperSpec-method}
\alias{\%*\%,hyperSpec,matrix-method}
\alias{\%*\%,matrix,hyperSpec-method}
\alias{\%/\%,hyperSpec,hyperSpec-method}
\alias{\%\%,hyperSpec,hyperSpec-method}
\alias{^,hyperSpec,hyperSpec-method}
\title{Arithmetical Operators for hyperSpec objects}
\usage{
\S4method{Arith}{hyperSpec,hyperSpec}(e1, e2)

\S4method{Arith}{hyperSpec,numeric}(e1, e2)

\S4method{Arith}{hyperSpec,matrix}(e1, e2)

\S4method{Arith}{hyperSpec,missing}(e1, e2)

\S4method{Arith}{numeric,hyperSpec}(e1, e2)

\S4method{Arith}{matrix,hyperSpec}(e1, e2)

\S4method{\%*\%}{hyperSpec,hyperSpec}(x, y)

\S4method{\%*\%}{hyperSpec,matrix}(x, y)

\S4method{\%*\%}{matrix,hyperSpec}(x, y)
}
\arguments{
\item{e1,e2}{or}

\item{x,y}{either two \code{hyperSpec} objects or

one \code{hyperSpec} object and  matrix of same size as \code{hyperSpec[[]]} or

a vector which length equalling either the number of rows or the number of wavelengths
of the hyperSpec object, or

a scalar (numeric of length 1).}
}
\value{
\code{hyperSpec} object with the new spectra matrix.
}
\description{
Arithmetical Operators: +, -, *, /, ^, \%\%, \%/\%, \%*\% for hyperSpec objects
}
\details{
The arithmetical operators \code{+}, \code{-}, \code{*}, \code{/}, \code{\^}, \code{\%\%},
\code{\%/\%},  and \code{\%*\%} for \code{hyperSpec} objects.

You can use these operators in different ways:
\preformatted{
e1 + e2
`+` (e1, e2)

x \%*\% y
`\%*\%`(x, y)

-x }
The arithmetical operators \code{+}, \code{-}, \code{*}, \code{/}, \code{^}, \code{\%\%},
\code{\%/\%}, and \code{\%*\%} work on the  spectra matrix of the \code{hyperSpec} object. They
have their usual meaning (see \code{\link[base]{Arithmetic}}).  The operators work also with one
\code{hyperSpec} object and a numeric object or a matrices of the same size as the spectra matrix
of the \code{hyperSpec} object.

With numeric vectors \code{\link[hyperSpec]{sweep}} is most probably more appropriate.

If you want to calculate on the extra data as well, use the data.frame \code{hyperSpec@data}
directly or \code{\link[hyperSpec]{as.data.frame} (x)}.
}
\examples{
flu + flu
1 / flu
all((flu + flu - 2 * flu)[[]] == 0)
-flu
flu / flu$c
}
\author{
C. Beleites
}
\seealso{
\code{\link[hyperSpec]{sweep-methods}} for calculations involving a vector and
  the spectral matrix.

  \code{\link[methods]{S4groupGeneric}} for group generic methods.

  \code{\link[base]{Arithmetic}} for the base arithmetic functions.

  \code{\link[hyperSpec]{Comparison}} for comparison operators,
  \code{\link[hyperSpec]{Math}} for mathematical group generic
  functions (Math and Math2 groups) working on \code{hyperSpec} objects.

\code{\link[base]{matmult}} for matrix multiplications with \code{\%*\%}.
}
\concept{
hyperSpec arithmetic

hyperSpec arithmetical operators

hyperSpec plus

hyperSpec division

hyperSpec spectra conversion

hyperSpec matrix multiplication
}
\keyword{arith}
\keyword{methods}

