% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_points_to_lines.R
\name{index_points_to_lines}
\alias{index_points_to_lines}
\alias{index_points_to_lines.data.frame}
\alias{index_points_to_lines.hy}
\title{Index Points to Lines}
\usage{
index_points_to_lines(
  x,
  points,
  search_radius = NULL,
  precision = NA,
  max_matches = 1
)

\method{index_points_to_lines}{data.frame}(
  x,
  points,
  search_radius = NULL,
  precision = NA,
  max_matches = 1
)

\method{index_points_to_lines}{hy}(
  x,
  points,
  search_radius = NULL,
  precision = NA,
  max_matches = 1
)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{points}{sf or sfc of type POINT in analysis projection. NOTE: x will
be projected to the projection of the points layer.}

\item{search_radius}{units distance for the nearest neighbor search
to extend in analysis projection. If missing or NULL, and points are in a lon
lat projection, a default of 0.01 degree is used, otherwise 200 m is used.
Conversion to the linear unit used by the provided crs of points is attempted.
See RANN nn2 documentation for more details.}

\item{precision}{numeric the resolution of measure precision in the output in meters.}

\item{max_matches}{numeric the maximum number of matches to return if multiple are
found in search_radius}
}
\value{
data.frame with five columns, point_id, id, aggregate_id,
aggregate_id_measure, and offset. point_id is the row or list element in the
point input.
}
\description{
given an sf point geometry column, return id, aggregate_id
(e.g. reachcode), and aggregate id measure for each point.
}
\details{
Note 1: Inputs are cast into LINESTRINGS. Because of this, the measure output
of inputs that are true multipart lines may be in error.

Note 2: This algorithm finds the nearest node in the input flowlines to
identify which flowline the point should belong to. As a second pass,
it can calculate the measure to greater precision than the nearest flowline
geometry node.

Note 3: Offset is returned in units consistent with the projection of
the input points.

Note 4: See \code{dfMaxLength} input to sf::st_segmentize() for details of
handling of precision parameter.

Note 5: "from" is downstream -- 0 is the outlet "to" is upstream -- 100 is the inlet
}
\examples{

\donttest{
if(require(nhdplusTools)) {
source(system.file("extdata", "sample_flines.R", package = "nhdplusTools"))

point <- sf::st_sfc(sf::st_point(c(-76.87479, 39.48233)),
                    crs = 4326)

index_points_to_lines(sample_flines, point)

point <- sf::st_transform(point, 5070)

index_points_to_lines(sample_flines, point,
                      search_radius = units::set_units(200, "m"))

index_points_to_lines(sample_flines, point, precision = 30)

index_points_to_lines(sample_flines,
                      sf::st_sfc(list(sf::st_point(c(-76.86934, 39.49328)),
                                      sf::st_point(c(-76.91711, 39.40884)),
                                      sf::st_point(c(-76.88081, 39.36354))),
                                 crs = 4326),
                      search_radius = units::set_units(0.2, "degrees"),
                      max_matches = 10)

 }
 }

}
