% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bedload.R
\name{bedload_MPM}
\alias{bedload_MPM}
\title{Bedload Transport Capacity (Meyer-Peter Müller)}
\usage{
bedload_MPM(dm, J, Rs, B, f_kSt = 0.85, t_crit = 0.047, rho_s = 2650, s = 2.65)
}
\arguments{
\item{dm}{Median grain size [m].}

\item{J}{Bottom slope [-].}

\item{Rs}{Hydraulic radius [m].}

\item{B}{Bottom width [m].}

\item{f_kSt}{Friction factor = (k_StS / k_Str)^(3/2) (default: 0.85).}

\item{t_crit}{Critical shear stress [-] (default: 0.047).}

\item{rho_s}{Density of bedload material [kg/m3] (default: 2650).}

\item{s}{Relative solid density [-] (default: 2.65).}
}
\value{
Returns the bedload transport rate [kg/s].
}
\description{
Calculates the bedload transport capacity using the formula by
Meyer-Peter Müller. The formula is valid for bed slopes less than 0.005.
}
\examples{
bedload_MPM(dm = 0.1, J = 0.01, Rs = 1.5, B = 20)
bedload_MPM(dm = 0.1, J = 0.01, Rs = 1.5, B = 20, t_crit = 0.06)

}
\references{
Bezzola, G.R. (2012). Vorlesungsmanuskript Flussbau. ETH Zürich, Versuchsanstalt für Wasserbau, Hydrologie und Glaziologie VAW.
}
