% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-WaterLevelDataFrame.R
\name{WaterLevelDataFrame}
\alias{WaterLevelDataFrame}
\title{Initialize a WaterLevelDataFrame}
\usage{
WaterLevelDataFrame(
  river = c("Elbe", "Rhine"),
  time,
  gauging_stations = NULL,
  gauging_stations_missing = NULL,
  comment = NULL,
  id = NULL,
  station = NULL,
  station_int = NULL,
  w = NULL
)
}
\arguments{
\item{river}{a required argument to fill the \linkS4class{WaterLevelDataFrame}-slot
\code{river}. It has to be type \code{character}, has to have a length of
one and can be either \strong{Elbe} or \strong{Rhine}.}

\item{time}{a required argument to fill the \linkS4class{WaterLevelDataFrame}-slot
\code{time}. It has to be type \code{\link[base:POSIXct]{c("POSIXct",
"POSIXt")}}, has to have a length of one and must be in the temporal range
between \code{1960-01-01 00:00:00 CET} and now (\code{Sys.time()}) or be
\code{NA}.}

\item{gauging_stations}{a slot of class \code{\link[base]{data.frame}}.
\code{gauging_stations} has to be a \code{\link[base]{data.frame}} with the
following columns and column types: id (\code{integer}), gauging_station
(\code{character}), uuid (\code{character}), km (\code{numeric}),
km_qps (\code{numeric}), river (\code{character}),
longitude (\code{numeric}), latitude (\code{numeric}), mw
(\code{numeric}), pnp (\code{numeric}), w (\code{numeric}), wl
(\code{numeric}), n_wls_below_w_do (\code{integer}),
n_wls_above_w_do (\code{integer}), n_wls_below_w_up
(\code{integer}), n_wls_above_w_up (\code{integer}),
name_wl_below_w_do (\code{character}), name_wl_above_w_do
(\code{character}), name_wl_below_w_up (\code{character}),
name_wl_above_w_up (\code{character}), w_wl_below_w_do
(\code{numeric}), w_wl_above_w_do (\code{numeric}), w_wl_below_w_up
(\code{numeric}), w_wl_above_w_up (\code{numeric}), weight_up
(\code{numeric}), weight_do (\code{numeric}).}

\item{gauging_stations_missing}{an optional argument to fill the
\linkS4class{WaterLevelDataFrame}-slot \code{gauging_stations_missing}. It
has to be type \code{character} and usually contains a vector with names of
gauging stations for which no water level information was available for the
specified \code{time}. This argument is used by the functions
\code{\link{waterLevel}}, \code{\link{waterLevelPegelonline}},
\code{\link{waterLevelFlys3}} and \code{\link{waterLevelFlys3Seq}}.}

\item{comment}{an optional argument to fill the
\linkS4class{WaterLevelDataFrame}-slot \code{comment}. It has to be type
\code{character} and is used by the functions
\code{\link{WaterLevelDataFrame}}, \code{\link{waterLevel}},
\code{\link{waterLevelPegelonline}}, \code{\link{waterLevelFlys3}} and \code{\link{waterLevelFlys3Seq}}.}

\item{id}{an optional argument to hand over the \code{row.names(wldf)}.
\code{id} has to be type \code{integer} and has to have the same length
as other optional arguments (\code{station}, \code{station_int} and
\code{w}) forming the \code{\link[base]{data.frame}}-component of a
\linkS4class{WaterLevelDataFrame}.}

\item{station}{an optional argument to hand over the stationing along the
specified \code{river}. If specified, it has to be type \code{numeric}
and has to have the same length as other optional arguments (\code{id},
\code{station_int} and \code{w}) forming the \code{\link[base]{data.frame}}-component
of a \linkS4class{WaterLevelDataFrame}. If both stationing arguments
(\code{station} and \code{station_int}) are specified, all elements of
\code{station} have to be equal to \code{as.numeric(station_int / 1000)}.
Minimum and maximum allowed values of \code{station} are
\code{river}-specific: Elbe (km 0 - 585.7), Rhine (km 336.2 - 865.7).}

\item{station_int}{an optional argument to hand over the stationing along the
specified \code{river}. If specified, it has to be type \code{integer}
and has to have the same length as other optional arguments (\code{id},
\code{station} and \code{w}) forming the \code{\link[base]{data.frame}}-component
of a \linkS4class{WaterLevelDataFrame}. If both stationing arguments
(\code{station} and \code{station_int}) are specified, all elements of
\code{station_int} have to be equal to \code{as.integer(station * 1000)}.
Minimum and maximum allowed values of \code{station_int} are \code{river}-specific:
Elbe (m 0 - 585700), Rhine (m 336200 - 865700).}

\item{w}{an optional argument to hand over the water level information along
the stationing of the specified \code{river} for a given \code{time}. If
specified, it has to be type \code{numeric} and has to have the same
length as other optional arguments (\code{id}, \code{station} and
\code{station_int}) forming the \code{\link[base]{data.frame}}-component of
a \linkS4class{WaterLevelDataFrame}. If not specified, the respective
\linkS4class{WaterLevelDataFrame}-column \code{w} can be computed by the
functions \code{\link{waterLevel}}, \code{\link{waterLevelPegelonline}},
\code{\link{waterLevelFlys3}} and \code{\link{waterLevelFlys3Seq}}. Minimum
and maximum allowed values of \code{w} are river-specific: Elbe (m a.s.l. 0
- 130), Rhine (m a.s.l. 5 - 120).}
}
\value{
The function produces an object of class
  \linkS4class{WaterLevelDataFrame} which might contain 1d water level data
  and information to recompute it.
}
\description{
To initialize an object of class \linkS4class{WaterLevelDataFrame}
  this function should be used. It checks all the required input data and
  validates the final object.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf <- waterLevel(wldf)

}
