% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping-functions.R
\name{by_regex}
\alias{by_regex}
\title{Map cells matching a string or regex to cell properties}
\usage{
by_regex(..., .grepl_args = list(), ignore_na = TRUE)
}
\arguments{
\item{...}{A list of name-value pairs. The names are regular expressions. If there is a single
unnamed argument, this is the default value for unmatched cells. More than one unnamed argument
is an error.}

\item{.grepl_args}{A list of arguments to pass to \code{\link[=grepl]{grepl()}}. Useful options
include \code{fixed}, \code{perl} and \code{ignore.case}.}

\item{ignore_na}{If \code{TRUE}, \code{NA} values in the result will be left unchanged
from their previous values. Otherwise, \code{NA}
normally resets to the default.}
}
\value{
A function for use in \verb{map_***} functions.
}
\description{
Map cells matching a string or regex to cell properties
}
\examples{
ht <- hux(c("The cat sat", "on the", "mat"))

map_bold(ht, by_regex("at" = TRUE))
map_bold(ht, by_regex("a.*a" = TRUE))

map_bold(ht, by_regex(
        "the" = TRUE,
        .grepl_args = list(
          ignore.case = TRUE
        )
      ))
}
\seealso{
\link{mapping-functions}

Other mapping functions: 
\code{\link{by_cases}()},
\code{\link{by_colorspace}()},
\code{\link{by_function}()},
\code{\link{by_quantiles}()},
\code{\link{by_ranges}()},
\code{\link{by_rows}()},
\code{\link{by_values}()}
}
\concept{mapping functions}
