% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{col_width}
\alias{col_width}
\alias{col_width<-}
\alias{set_col_width}
\title{Column widths}
\usage{
col_width(ht)
col_width(ht) <- value
set_col_width(ht, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector. If numeric, they are treated as proportions of the table width. If character, they must be valid CSS or LaTeX lengths.}

\item{col}{A col specifier. See \link{rowspecs} for details.}
}
\value{
For \code{col_width}, the \code{col_width} property.
For \code{set_col_width}, the modified huxtable.
}
\description{
Functions to get or set the \emph{column widths} property of huxtable cols.
}
\details{
In LaTeX, if you specify a column width, but set \code{wrap} to \code{FALSE} and have cells which
overrun, then you may have problems with table position and with background colours in other cells.
The workaround is to adjust the width, so that your cells no longer overrun.
}
\examples{

col_width(jams) <-  c(.2, .8)
col_width(jams)

}
\seealso{
Other row/column heights: \code{\link{row_height}}
}
\concept{row/column heights}
