% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{background_color}
\alias{background_color}
\alias{background_color<-}
\alias{set_background_color}
\alias{background_color.huxtable}
\alias{background_color<-.huxtable}
\title{Get or Set Cell Background Color}
\usage{
background_color(ht)
background_color(ht) <- value
set_background_color(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector or matrix of R colors. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{background_color}, the \code{background_color} attribute.
For \code{set_background_color}, the \code{ht} object.
}
\description{
Functions to get or set the cell background color property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
background_color(ht) <-  grey(.95)
background_color(ht)

}
\seealso{
Other formatting functions: \code{\link{bold}},
  \code{\link{font_size}}, \code{\link{font}},
  \code{\link{na_string}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
