% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_pattern.R
\name{find_pattern_in}
\alias{find_pattern_in}
\title{Find string pattern in (text) file}
\usage{
find_pattern_in(file_contents, basedir = ".", reader = readLines,
  include.comments = FALSE, use.OS = FALSE,
  file_pattern = "\\\\.(R|r)(nw|md)?$", file.ext = NULL)
}
\arguments{
\item{file_contents}{A perl-regular expression as a search query.}

\item{basedir}{The root of the directory tree in which files will be searched recursively.}

\item{reader}{A function, akin to \code{base::readLines}, the default, that accepts a filename and returns a character vector.}

\item{include.comments}{If \code{FALSE}, the default, comments (i.e. anything after a \code{\#}) are not searched.}

\item{use.OS}{Use the operating system to determine file list. Only available on Windows. If it fails, a fall-back option
(using \code{dir}) is used.}

\item{file_pattern}{A regular expression passed to \code{list.files(pattern = file.ext)}. 
By default, \code{"\\.(R|r)(nw|md)?$"}, i.e. all R and Sweave files. (Does not have to be a file extension.)}

\item{file.ext}{A file extension passed to the operating system if \code{use.OS} is used.}
}
\value{
A \code{data.table}, one row per filename with a match, including the first line that matched.
}
\description{
Find string pattern in (text) file
}
