% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{MR}
\alias{MR}
\title{calculate mixing ratio}
\usage{
MR(q)
}
\arguments{
\item{q}{specific humidity \eqn{q} (\eqn{kg/kg})}
}
\value{
numeric mixing ratio \eqn{\omega} (\eqn{kg/kg})
}
\description{
calculate mixing ratio \eqn{\omega} based on specific humidity \eqn{q}
}
\examples{
t <- 273.15
Es <- SVP(t)
e <- WVP2(70, Es)
q <- SH(e, p = 101325)
MR(q)
}
\seealso{
\code{\link{SH}}.
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Department of Earth System Science, Tsinghua University
}
