% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.immunog.locs}
\alias{get.immunog.locs}
\title{Retrieve locations of Immunoglobin regions across the genome}
\usage{
get.immunog.locs(build = NULL, bioC = TRUE, text = FALSE,
  GRanges = TRUE)
}
\arguments{
\item{build}{string, currently 'hg18' or 'hg19' to specify which annotation version to use. 
Default is build-36/hg-18. Will also accept integers 36,37 as alternative arguments.}

\item{bioC}{logical, whether to return the annotation as a ranged S4 object (GRanges or
RangedData), or as a data.frame}

\item{text}{logical, whether to return locations as a text vector of the form: chrN:xxxx-xxxx}

\item{GRanges}{logical, whether to return a GRanges object, or FALSE to return RangedData}
}
\value{
Returns a list, GRanges or RangedData object, depending on input parameters. Contained
will be immunoglobin chromosome, start and end positions.
}
\description{
Returns the locations of immunoglobin regions in the human genome, for a given build, as
a list by chromosome, text vector, or GRanges/RangedData object.
For instance, for CNV research, these regions are known to be highly structurally complex
and can lead to false positive CNV-calls, so are often excluded.
}
\examples{
get.immunog.locs()
get.immunog.locs(bioC=FALSE)
get.immunog.locs(text=TRUE,build=37)
}
