% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{conv.38.37}
\alias{conv.38.37}
\title{Convert from build 38 to build 37 SNP coordinates}
\usage{
conv.38.37(ranges = NULL, chr = NULL, pos = NULL, ..., ids = NULL)
}
\arguments{
\item{ranges}{optional GRanges or RangedData object describing positions for which conversion
should be performed. No need to enter chr, pos if using ranges}

\item{chr}{character, an optional vector of chromosomes to combine with 'pos' to describe
positions to convert from build hg38 to hg19}

\item{pos}{integer, an optional vector of chromosome positions (for SNPs), no need to enter
a ranges object if this is provided along with 'chr'}

\item{...}{additional arguments to makeGRanges(), so in other words, can use 'start' and
'end' to specify ranges instead of 'pos'.}

\item{ids}{if the ranges have ids (e.g, SNP ids, CNV ids), then by including this parameter
when using chr, pos input, the output object will have these ids as rownames. For ranges input
these ids would already be in the rownames of the GRanges or RangedData object, so use of
this parameter should be unnecessary}
}
\value{
Returns positions converted from build 38 to 37. If using the 'ranges' parameter 
for position input, the object returned will be of the same format. If using chr and pos 
to input, then the object returned will be a data.frame with columns, chr and pos with 
rownames 'ids'. Output will be the same length as the input, which is not necessarily the
 case for liftOver() which does the core part of this conversion. Using vector or GRanges 
 input will give a resulting data.frame or GRanges object respectively that has the same
 order of rownames as the original input. Using RangedData will result in an output that
  is sorted by genome order, regardless of the original order.
}
\description{
Convert range or SNP coordinates between builds using a chain file. Depending on the chain file
this can do any conversion, but the default will use the hg38 to hg19 (38-->37) chain file
built into this package. The positions to convert can be entered using using chr, pos vectors,
 or a RangedData or GRanges object. This function is a wrapper for liftOver() from rtracklayer,
providing more control of input and output and 'defensive' preservation of order and length
of the output versus the input ranges/SNPs.
}
\examples{
\donttest{
gene.labs <- c("CTLA4","IL2RA","HLA-C")
pp <- Pos.gene(gene.labs,build=38)
gg <- GRanges(ranges=IRanges(start=pp$start,end=pp$end),seqnames=pp$chr)
conv.38.37(gg) # order of output is preserved   ### HERE!!! ###
rr <- as(gg,"RangedData")
conv.38.37(rr) # note the result is same as GRanges, but in genome order
}
}
\seealso{
\code{\link{conv.36.37}}, \code{\link{conv.37.36}}, 
\code{\link{conv.37.38}}, \code{\link{convTo37}}, \code{\link{convTo36}}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
