% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{format_period}
\alias{format_period}
\title{Reformat Period-Separated Names}
\usage{
format_period(names)
}
\arguments{
\item{names}{a vector of names following this convention. Names that lack periods will
be returned entirely intact, so assuming you don't have (legitimate) periods in names
not following this format, there's no need to worry if your vector has mixed formatting.}
}
\description{
a common pattern for names is for first and middle names to be represented
by initials. Unfortunately depending on how this is done, that can make things problematic;
"G. K. Chesterton" is easy to parse, but "G.K. Chesterton" or "G.K.Chesterton" is not.
\code{format_period} takes names that are period-separated in this fashion and reformats
them to ensure there are spaces between each initial. Periods after any space in the name
are preserved, so "G.K. Chesterton, M.D." does not become "G. K. Chesterton, M. D. ".
}
\examples{
format_period("G.K.Chesterton")
}
\seealso{
\code{\link{format_reverse}} for names stored as "Lastname, Firstname", and
\code{\link{parse_names}} to parse the output of this function.
}

