% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_print.R
\name{label_print}
\alias{label_print}
\title{Label print}
\usage{
label_print(
  label,
  mode = "sample",
  filename = "labels",
  margin = 0.04,
  paper = c(21, 29.7),
  units = "cm",
  viewer = FALSE,
  smpres = 200,
  nlabels = NA
)
}
\arguments{
\item{label}{Data frame to build the labels or n repeated labels}

\item{mode}{Label in "sample/preview" or "complete" mode}

\item{filename}{Labels file name}

\item{margin}{Labels margins. margin(t = 0, r = 0, b = 0, l = 0)}

\item{paper}{Paper size. Default A4 (21.0 x 29.7)}

\item{units}{Units for the label options}

\item{viewer}{Show the sample in the "Plots" or "Viewer" panel}

\item{smpres}{Sample resolution}

\item{nlabels}{Number of labels to generate}
}
\value{
pdf
}
\description{
Generate labels based in a data frame
}
\examples{

library(huito)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
       , "1q0EZmZBt52ca-0VbididjJy2jXTwf06laJpzvkQJWvc/edit#gid=107939497")
fb <- gsheet2tbl(url)

# huito_fonts()

label <- label_layout(data = fb, size = c(10, 2.5)) \%>\%
         include_image(
               value = "https://flavjack.github.io/inti/img/inkaverse.png"
               , size = c(2.2, 2.2)
               , position = c(1.2, 1.25)
               ) \%>\%
         include_barcode(
               value = "qr-code"
               , size = c(2.2, 2.2)
               , position = c(8.3, 1.25)
               ) \%>\%
         include_text(value = "plots", position = c(9.7, 1.25), angle = 90, size = 15) \%>\%
         include_text(value = "Inkaverse"
         , position = c(3, 1.25), size = 18, opts = list(hjust = 0.0, vjust = 0.0)) \%>\%
         label_print("sample")

}
