% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_qualite_rivieres.R
\name{get_qualite_rivieres_analyse}
\alias{get_qualite_rivieres_analyse}
\alias{get_qualite_rivieres_analyse_pc}
\alias{get_qualite_rivieres_condition_environnementale}
\alias{get_qualite_rivieres_condition_environnementale_pc}
\alias{get_qualite_rivieres_operation}
\alias{get_qualite_rivieres_operation_pc}
\alias{get_qualite_rivieres_station}
\alias{get_qualite_rivieres_station_pc}
\title{Retrieve data from API "Qualité physico-chimique des cours d'eau"}
\usage{
get_qualite_rivieres_analyse(...)

get_qualite_rivieres_analyse_pc(...)

get_qualite_rivieres_condition_environnementale(...)

get_qualite_rivieres_condition_environnementale_pc(...)

get_qualite_rivieres_operation(...)

get_qualite_rivieres_operation_pc(...)

get_qualite_rivieres_station(...)

get_qualite_rivieres_station_pc(...)
}
\arguments{
\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
The "Quality of rivers" API data comes from the Naïades database.
Available for the whole of France (including the French overseas departments
and territories), they relate to the results of measurements of the
physico-chemical quality of rivers and water bodies transmitted by the Water
Agencies.

Available endpoints are:
\itemize{
\item \code{get_qualite_rivieres_station} retrieves physico-chemical measuring stations
\item \code{get_qualite_rivieres_operation} retrieves physico-chemical operations
\item \code{get_qualite_rivieres_analyse} retrieves physico-chemical analyses
\item \code{get_qualite_rivieres_condition_environnementale} retrieves physico-chemical
environmental conditions for analyses (please note that pagination is based
on the number of analyses)
}

See the API documentation for available filter parameters: \url{https://hubeau.eaufrance.fr/page/api-qualite-cours-deau}
}
\details{
Endpoints ending by \verb{_pc} are aliases of the functions without the suffix \verb{_pc}.
}
\examples{
\dontrun{
# Tutorial provided by https://hubeau.eaufrance.fr/page/api-qualite-cours-deau-tuto

# List of stations in Longuyon
get_qualite_rivieres_station(libelle_commune="Longuyon")
# ... with field selection
get_qualite_rivieres_station(
  libelle_commune = "Longuyon",
  fields = c("code_station",
             "libelle_station",
             "localisation_precise",
             "code_commune",
             "libelle_commune",
             "code_cours_eau",
             "nom_cours_eau")
)

# Query results of nitrate analyses at the station since 2013
get_qualite_rivieres_analyse(
  code_station = "02115725",
  libelle_parametre = "Nitrates",
  date_debut_prelevement = "2013-01-01",
  code_qualification = 1,
  fields = c("code_station",
             "libelle_station",
             "code_parametre",
             "libelle_parametre",
             "date_prelevement",
             "resultat",
             "symbole_unite",
             "code_remarque",
             "mnemo_remarque",
             "code_statut",
             "mnemo_statut",
             "code_qualification",
             "libelle_qualification")
)

# dates sorted from most recent to oldest
get_qualite_rivieres_analyse(
  code_station = "02115725",
  libelle_parametre = "Nitrates",
  date_debut_prelevement = "2013-01-01",
  code_qualification = 1,
  fields = c("code_station",
             "libelle_station",
             "code_parametre",
             "libelle_parametre",
             "date_prelevement",
             "resultat",
             "symbole_unite",
             "code_remarque",
             "mnemo_remarque",
             "code_statut",
             "mnemo_statut",
             "code_qualification",
             "libelle_qualification"),
 sort = "desc"
)

# Nitrate analysis results since 1 August 2016 for 5 stations
get_qualite_rivieres_analyse(
  code_station = c("02115725",
                   "02115650",
                   "02115685",
                   "02115700",
                   "02115715"),
  libelle_parametre = "Nitrates",
  date_debut_prelevement = "2016-08-01",
  code_qualification = 1,
  fields = c("code_station",
             "libelle_station",
             "libelle_parametre",
             "date_prelevement",
             "resultat",
             "symbole_unite",
             "code_remarque"),
 sort = "desc"
)

# Geographical search by distance
get_qualite_rivieres_station(longitude = 5.62,
                             latitude = 49.44,
                             distance = 8,
                             fields = c("code_station", "libelle_station"))

}
}
