% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-options.R
\name{req_user_agent}
\alias{req_user_agent}
\title{Set user-agent for a request}
\usage{
req_user_agent(req, string = NULL)
}
\arguments{
\item{req}{A \link{request}.}

\item{string}{String to be sent in the \code{User-Agent} header. If \code{NULL},
will user default.}
}
\value{
A modified HTTP \link{request}.
}
\description{
This overrides the default user-agent set by httr2 which includes the
version numbers of httr2, the curl package, and libcurl.
}
\examples{
# Default user-agent:
request("http://example.com") |> req_dry_run()

request("http://example.com") |> req_user_agent("MyString") |> req_dry_run()

# If you're wrapping in an API in a package, it's polite to set the
# user agent to identify your package.
request("http://example.com") |>
  req_user_agent("MyPackage (http://mypackage.com)") |>
  req_dry_run()
}
