% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpgd.R
\name{hgd_plot}
\alias{hgd_plot}
\title{Render httpgd plot.}
\usage{
hgd_plot(
  page = 0,
  width = -1,
  height = -1,
  zoom = 1,
  renderer = "svg",
  which = dev.cur(),
  file = NA
)
}
\arguments{
\item{page}{Plot page to render. If this is set to \code{0}, the last page will
be selected. Can be set to a numeric plot index or plot ID
(see \code{\link[=hgd_id]{hgd_id()}}).}

\item{width}{Width of the plot. If this is set to \code{-1}, the last width will
be selected.}

\item{height}{Height of the plot. If this is set to \code{-1}, the last height
will be selected.}

\item{zoom}{Zoom level. (For example: \code{2} corresponds to 200\%, \code{0.5} would
be 50\%.)}

\item{renderer}{Renderer.}

\item{which}{Which device (ID).}

\item{file}{Filepath to save SVG. (No file will be created if this is NA)}
}
\value{
Rendered SVG string.
}
\description{
This function will only work after starting a device with \code{\link[=hgd]{hgd()}}.
}
\examples{
hgd()

plot(1, 1)
s <- hgd_plot(width = 600, height = 400)

hist(rnorm(100))
tf <- tempfile()
on.exit(unlink(tf))
hgd_plot(file = tf, width = 600, height = 400)

dev.off()
}
