% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hep_clearance.R
\name{calc_hep_clearance}
\alias{calc_hep_clearance}
\title{Calculate the hepatic clearance.}
\usage{
calc_hep_clearance(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  parameters = NULL,
  species = "Human",
  default.to.human = FALSE,
  hepatic.model = "well-stirred",
  suppress.messages = FALSE,
  well.stirred.correction = TRUE,
  restrictive.clearance = TRUE,
  adjusted.Funbound.plasma = TRUE,
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_steadystate
function, overrides chem.name and chem.cas.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{hepatic.model}{Model used in calculating hepatic clearance, unscaled,
parallel tube, dispersion, or default well-stirred.}

\item{suppress.messages}{Whether or not to suppress the output message.}

\item{well.stirred.correction}{Uses correction in calculation of hepatic
clearance for well-stirred model if TRUE for hepatic.model well-stirred.
This assumes clearance relative to amount unbound in whole blood instead of
plasma, but converted to use with plasma concentration.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE.}

\item{...}{Additional parameters passed to parameterize_steadystate if
parameters is NULL.}
}
\value{
\item{Hepatic Clearance}{Units of L/h/kg BW.}
}
\description{
This function calculates the hepatic clearance in plasma for using the
Houston (2004) are also available. In vitro measured hepatic clearace is 
corrected for the free fraction in the assay using the model of Kilford et 
al. (2008).
}
\examples{

calc_hep_clearance(chem.name="Ibuprofen",hepatic.model='unscaled')
calc_hep_clearance(chem.name="Ibuprofen",well.stirred.correction=FALSE)


}
\references{
Ito, K., & Houston, J. B. (2004). "Comparison of the use of liver models for 
predicting drug clearance using in vitro kinetic data from hepatic microsomes 
and isolated hepatocytes." Pharmaceutical Tesearch, 21(5), 785-792.

Kilford, P. J., Gertz, M., Houston, J. B. and Galetin, A.
(2008). Hepatocellular binding of drugs: correction for unbound fraction in
hepatocyte incubations using microsomal binding or drug lipophilicity data.
Drug Metabolism and Disposition 36(7), 1194-7, 10.1124/dmd.108.020834.
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
