% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameterize_gas_PBTK.R
\name{parameterize_gas_pbtk}
\alias{parameterize_gas_pbtk}
\title{Parameterize_gas_pbtk}
\usage{
parameterize_gas_pbtk(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  default.to.human = F,
  tissuelist = list(liver = c("liver"), kidney = c("kidney"), lung = c("lung"), gut =
    c("gut")),
  force.human.clint.fup = F,
  clint.pvalue.threshold = 0.05,
  adjusted.Funbound.plasma = T,
  regression = T,
  vmax = 0,
  km = 1,
  exercise = F,
  fR = 12,
  VT = 0.75,
  VD = 0.15,
  suppress.messages = F,
  minimum.Funbound.plasma = 1e-04,
  ...
)
}
\arguments{
\item{chem.cas}{Either the chemical name or the CAS number must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{http://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing animal values with human values
if true (hepatic intrinsic clearance or fraction of unbound plasma).}

\item{tissuelist}{Specifies compartment names and tissues groupings.
Remaining tissues in tissue.data are lumped in the rest of the body.
However, solve_pbtk only works with the default parameters.}

\item{force.human.clint.fup}{Forces use of human values for hepatic
intrinsic clearance and fraction of unbound plasma if true.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{adjusted.Funbound.plasma}{Returns adjusted Funbound.plasma when set to
TRUE along with parition coefficients calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{vmax}{Michaelis-Menten vmax value in reactions/min}

\item{km}{Michaelis-Menten concentration of half-maximal reaction velocity
in desired output concentration units.}

\item{exercise}{Logical indicator of whether to simulate an exercise-induced
heightened respiration rate}

\item{fR}{Respiratory frequency (breaths/minute), used especially to adjust
breathing rate in the case of exercise. This parameter, along with VT and VD
(below) gives another option for calculating Qalv (Alveolar ventilation) 
in case pulmonary ventilation rate is not known}

\item{VT}{Tidal volume (L), to be modulated especially as part of simulating
the state of exercise}

\item{VD}{Anatomical dead space (L), to be modulated especially as part of
simulating the state of exercise}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{...}{Other parameters}
}
\value{
\item{BW}{Body Weight, kg.} 
\item{Clint}{Hepatic intrinsic clearance, uL/min/10^6 cells}
\item{Clint.dist}{Distribution of hepatic intrinsic clearance values
(median, lower 95th, upper 95th, p value)} 
\item{Clmetabolismc}{Hepatic Clearance, L/h/kg BW.} 
\item{Fgutabs}{Fraction of the oral dose absorbed, i.e. the fraction of the
dose that enters the gut lumen.}
\item{Fhep.assay.correction}{The fraction of chemical unbound in hepatocyte
assay using the method of Kilford et al. (2008)} 
\item{Funbound.plasma}{Fraction of chemical unbound to plasma.} 
\item{Funbound.plasma.adjustment}{Fraction unbound to plasma adjusted as
described in Pearce et al. 2017}
\item{Funbound.plasma.dist}{Distribution of fraction unbound to plasma
(median, lower 95th, upper 95th)}
\item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{Kblood2air}{Ratio of concentration of chemical in blood to air}
\item{Kgut2pu}{Ratio of concentration of chemical in gut tissue to unbound
concentration in plasma.} 
\item{kgutabs}{Rate that chemical enters the gut from gutlumen, 1/h.} 
\item{Kkidney2pu}{Ratio of concentration of chemical in kidney tissue to
unbound concentration in plasma.} 
\item{Kliver2pu}{Ratio of concentration of chemical in liver tissue to
unbound concentration in plasma.} 
\item{Klung2pu}{Ratio of concentration of chemical in lung tissue
to unbound concentration in plasma.} 
\item{km}{Michaelis-Menten concentration of half-maximal activity}
\item{Kmuc2air}{Mucus to air partition coefficient}
\item{Krbc2pu}{Ratio of concentration of chemical in red blood cells to
unbound concentration in plasma.}
\item{Krest2pu}{Ratio of concentration of chemical in rest of body tissue to
unbound concentration in plasma.} 
\item{kUrtc}{Unscaled upper respiratory tract uptake parameter (L/h/kg^0.75)}
\item{liver.density}{Density of liver in g/mL}
\item{MA}{phospholipid:water distribution coefficient, membrane affinity}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.} 
\item{MW}{Molecular Weight, g/mol.}
\item{pKa_Accept}{compound H association equilibrium constant(s)}
\item{pKa_Donor}{compound H dissociation equilibirum constant(s)}
\item{Pow}{octanol:water partition coefficient (not log transformed)}
\item{Qalvc}{Unscaled alveolar ventilation rate (L/h/kg^0.75)}
\item{Qcardiacc}{Cardiac Output, L/h/kg BW^3/4.} 
\item{Qgfrc}{Glomerular Filtration Rate, L/h/kg BW^0.75, volume of fluid
filtered from kidney and excreted.} 
\item{Qgutf}{Fraction of cardiac output flowing to the gut.}
\item{Qkidneyf}{Fraction of cardiac output flowing to the kidneys.}
\item{Qliverf}{Fraction of cardiac output flowing to the liver.}
\item{Qlungf}{Fraction of cardiac output flowing to lung tissue.}
\item{Qrestf}{Fraction of blood flow to rest of body}
\item{Rblood2plasma}{The ratio of the concentration of the chemical in the
blood to the concentration in the plasma from available_rblood2plasma.}
\item{Vartc}{Volume of the arteries per kg body weight, L/kg BW.}
\item{Vgutc}{Volume of the gut per kg body weight, L/kg BW.}
\item{Vkidneyc}{Volume of the kidneys per kg body weight, L/kg BW.}
\item{Vliverc}{Volume of the liver per kg body weight, L/kg BW.}
\item{Vlungc}{Volume of the lungs per kg body weight, L/kg BW.}
\item{vmax}{Michaelis-Menten maximum reaction velocity (1/min)}
\item{Vmucc}{Unscaled mucosal volume (L/kg BW^0.75}
\item{Vrestc}{ Volume of the rest of the body per kg body weight, L/kg BW.}
\item{Vvenc}{Volume of the veins per kg body weight, L/kg BW.}
}
\description{
This function initializes the parameters needed in the function solve_gas_pbtk
}
\examples{
parameters <- parameterize_gas_pbtk(chem.cas='129-00-0')

parameters <- parameterize_gas_pbtk(chem.name='pyrene',species='Rat')

parameterize_gas_pbtk(chem.cas = '56-23-5')

parameters <- parameterize_gas_pbtk(chem.name='Carbon tetrachloride',species='Rat')

# Change the tissue lumping:
compartments <- list(liver=c("liver"),fast=c("heart","brain","muscle","kidney"),
                      lung=c("lung"),gut=c("gut"),slow=c("bone"))
parameterize_gas_pbtk(chem.name="Bisphenol a",species="Rat",default.to.human=TRUE,
                   tissuelist=compartments) 

}
\references{
Linakis, Matthew W., et al. "Development and Evaluation of a High Throughput 
Inhalation Model for Organic Chemicals", submitted

Kilford, P. J., Gertz, M., Houston, J. B. and Galetin, A.
(2008). Hepatocellular binding of drugs: correction for unbound fraction in
hepatocyte incubations using microsomal binding or drug lipophilicity data.
Drug Metabolism and Disposition 36(7), 1194-7, 10.1124/dmd.108.020834.
}
\author{
Matt Linakis, Robert Pearce, John Wambaugh
}
\keyword{Parameter}
