% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_convert_hubeau.R
\name{d_convert_hubeau}
\alias{d_convert_hubeau}
\title{Convert Hubeau station files into a htsr sqlite base}
\usage{
d_convert_hubeau(hubeau.dir, station.id, fsqname = "hubeau")
}
\arguments{
\item{hubeau.dir}{Full path of the hubeau folder (character)}

\item{station.id}{Id list of the stations to convert (character)}

\item{fsqname}{Name of the sqlite data base without extension (default = "hubeau")}
}
\description{
Convert a Hubeau  hydrological file into a htsr sqlite base. It regards
the "basic" data file, which includes water level and discharge data. .
}
\details{
The data base is build from selected stations in the "stations.tar" file available on the data.eau.france web site.
This file must be first downloaded and extracted in the folder hubeau.dir. For the extraction the R
function untar() can be used.
Secondly Within the hubeau.dir, the file stations/stations.csv give the full list of the available stations. One or more station ids
must be chosen and included in the station.id list parameter.

The units of water level data is cm and of discharge data is m3/s.
}
\author{
P. Chevallier - jul 2024
}
