% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cortestClust.R
\name{cortestClust}
\alias{cortestClust}
\alias{cortestClust.default}
\alias{cortestClust.formula}
\title{Test for Marginal Association Between Paired Clustered Data}
\usage{
cortestClust(x, ...)

\method{cortestClust}{default}(
  x,
  y,
  id,
  method = c("pearson", "kendall", "spearman"),
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)

\method{cortestClust}{formula}(formula, id, data, subset, na.action, ...)
}
\arguments{
\item{x, y}{numeric vectors of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{id}{a vector or factor object which identifies the clusters. The length of \code{id} should be the
same as the number of observations.}

\item{method}{a character string indicating which correlation coefficient is to be used for the test.
One of "\code{pearson}", "\code{kendall}", or "\code{spearman}". Can be abbreviated.}

\item{alternative}{indicates the alternative hypothesis and must be one of "\code{two.sided}", "\code{greater}",
or "\code{less}".You can specify just the initial letter. "\code{greater}" corresponds to positive association,
"\code{less}" to negative association.}

\item{conf.level}{confidence level for the returned confidence interval.}

\item{formula}{a formula of the form ~ u + v, where each of \code{u} and \code{v} are numeric variables
giving the data values for one sample. The samples must be of the sample length.}

\item{data}{an optional matrix or data frame containing variables in the formula \code{formula}. By default the
variables are taken from \code{environment(formula)}.}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when data contain \code{NA}s. Defaults to
\code{getOption("na.action")}.}
}
\value{
A list with class "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the estimated measure of marginal association, with name "\code{cluster-weighted cor}",
"\code{cluster-weighted tau}", or "\code{cluster-weighted rho}" corresponding to the method employed.}
\item{null.value}{the value of the association measure under the null hypothesis, always 0.}
\item{conf.int}{a confidence interval for the measure of association.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string indicating how the association was measured.}
\item{data.name}{a character string giving the name(s) of the data and the total number of clusters.}
\item{M}{the number of clusters.}
}
\description{
Test for association between paired samples in clustered data with potentially
informative cluster size.
}
\details{
The three methods each estimate the marginal association between paired observations from
clustered data and compute a test of the value being zero.

If \code{method} is "\code{pearson}" ("\code{kendall}"), the test statistic is based on the
Pearson product-moment (Kendall concordance coefficient) analog of Lorenz \emph{et al.} (2011).

If \code{method} is "\code{spearman}", the test statistic
is based on the Spearman coefficient analog of Lorenz \emph{et al.} (2018) modified for paired data.
}
\examples{
data(screen8)
cortestClust(screen8$read, screen8$math, screen8$sch.id)

## Formula interface.
cortestClust(~ math + read, sch.id, data=screen8, method="kendall")

}
\references{
Lorenz, D., Datta, S., Harkema, S. (2011) Marginal association measures for clustered data.
\emph{Statistics in Medicine}, \bold{30}, 3181--3191.

Lorenz, D., Levy, S., Datta, S. (2018) Inferring marginal association with paired and unpaired
clustered data. \emph{Stat. Methods Med. Res.}, \bold{27}, 1806--1817.
}
