% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{kosambi}
\alias{kosambi}
\title{Kosambi's genetic map function}
\usage{
kosambi(x, inverse = F)
}
\arguments{
\item{x}{vector of recombination rates}

\item{inverse}{logical, if FALSE recombination rate is mapped to Morgan unit,
if TRUE Morgan unit is mapped to recombination rate (default is FALSE)}
}
\value{
vector of genetic positions in Morgan units
}
\description{
Calculation of genetic distances from recombination rates
}
\examples{
  kosambi(seq(0, 0.5, 0.01))
}
\references{
Kosambi D.D. (1944) The estimation of map distance from
  recombination values. Ann. Eugen. 12: 172-175.
}
