% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hedModel.R
\name{hedModel}
\alias{hedModel}
\title{Estimate hedonic model for index creation}
\usage{
hedModel(estimator, hed_df, hed_spec, ...)
}
\arguments{
\item{estimator}{Type of model to estimates (base, robust, weighted)}

\item{hed_df}{Repeat sales dataset from hedCreateSales()}

\item{hed_spec}{Model specification (`formula` object)}

\item{...}{Additional arguments}
}
\value{
`hedmodel` object: model object of the estimator (ex.: `lm`)
}
\description{
Estimate coefficients for an index via the hedonic approach (generic method)
}
\section{Further Details}{

`estimator` argument must be in a class of 'base', 'weighted' or 'robust'
This function is not generally called directly, but rather from `hpiModel()`
}

\examples{

 # Load example data
 data(ex_sales)

 # Create hedonic data
 hed_data <- hedCreateTrans(trans_df = ex_sales,
                           prop_id = 'pinx',
                           trans_id = 'sale_id',
                           price = 'sale_price',
                           date = 'sale_date',
                           periodicity = 'monthly')

 # Estimate Model
 hed_model <- hedModel(estimator = structure('base', class = 'base'),
                       hed_df = hed_data,
                       hed_spec = as.formula(log(price) ~ baths + tot_sf))

}
