% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingheterogeneity.R
\name{latentIndex}
\alias{latentIndex}
\alias{healthIndex}
\title{Calculate the latent index}
\usage{
latentIndex(model, decreasing.levels = TRUE, subset = NULL,
  plotf = FALSE, response = c("data", "fitted", "Jurges"),
  ylab = "Latent index", ...)

healthIndex(model, decreasing.levels = TRUE, subset = NULL,
  plotf = FALSE, response = c("data", "fitted", "Jurges"),
  ylab = "Latent index", ...)
}
\arguments{
\item{model}{a fitted \code{hopit} model.}

\item{decreasing.levels}{a logical indicating whether self-reported (e.g., health) classes are ordered in decreasing order.}

\item{subset}{an optional vector that specifies a subset of observations.}

\item{plotf}{a logical indicating whether to plot the summary figure.}

\item{response}{X-axis plotting option; choose \code{'data'} for the raw responses and \code{'fitted'} for the responses reclassified by the model.}

\item{ylab}{a label of the y-axis.}

\item{...}{further parameters passed to the \code{\link{plot}} function.}
}
\value{
a vector with a latent index for each individual.
}
\description{
Calculate the latent index from the fitted model. The latent index is a standardized latent measure that takes values from 0 to 1, where
0 refers to the worst predicted state (the maximal observed value for the latent measure) and 1 refers
to the best predicted state (the minimal observed value for the latent measure).
}
\examples{
# DATA
data(healthsurvey)

# the order of response levels decreases from the best health to
# the worst health; hence the hopit() parameter decreasing.levels
# is set to TRUE
levels(healthsurvey$health)

# Example 1 ---------------------

# fit a model
model1 <- hopit(latent.formula = health ~ hypertension + high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# calculate the health index and plot the reported health status
# versus the health index.
hi <- latentIndex(model1, plotf = TRUE, response = "data",
                  ylab = 'Health index', col='deepskyblue3')

# plot a simple histogram of the function output
hist(hi)

# calculate the health index and plot the adjusted health status vs. the health index
# using Jurges (Jurges 2007) method.
latentIndex(model1, plotf = TRUE, response = "Jurges",
                 ylab = 'Health index', col='deepskyblue3')

# calculate the health index and plot the model-predicted health levels
# versus the health index.
latentIndex(model1, plotf = TRUE, response = "fitted",
                 ylab = 'Health index', col='deepskyblue3')

}
\references{
\insertRef{Jurges2007}{hopit}\cr\cr
\insertRef{OKSUZYAN2019}{hopit}
}
\seealso{
\code{\link{standardizeCoef}}, \code{\link{getCutPoints}}, \code{\link{getLevels}}, \code{\link{hopit}}.
}
\author{
Maciej J. Danko
}
