% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualise.R
\name{visualise}
\alias{visualise}
\title{Visualise the HMM-A}
\usage{
visualise(model, numDigitsRound = 2)
}
\arguments{
\item{model}{The model.}

\item{numDigitsRound}{The amount of decimals that should be presented in the
graph.}
}
\description{
The function \cite{visualise} shows a graphical representation of the found
HMM-A. Only the initial distribution and transition distribution are shown.
Each state contains a Bayesian network, these would be unreadble when
displayed within each state. The \code{bnlearn}
\code{\link[bnlearn]{graphviz.plot}} method is used to display the bayesian
networks.
}
\examples{
# First, we need a model that we want to visualise, we create
# one using the learnModel function.
fit <- learnModel(data = hmmaExampleData, amountOfStates = 3)

# To visualise the states and transitions, we use the visualise method
visualise(fit)

# To visualise the BNs within the states, use the code below
library(bnlearn)
graphviz.plot(fit$parms.emission[[1]])

}
