# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @useDynLib hmlasso
#' @importFrom Rcpp sourceCpp evalCpp
NULL

#' calculate covariance matrix
#'
#' @param X design matrix
#' @return covariance matrix
#' @keywords internal
#'
covC <- function(X) {
    .Call('_hmlasso_covC', PACKAGE = 'hmlasso', X)
}

#' soft thresholding function
#'
#' @param z z
#' @param g gamma
#' @return value
#' @keywords internal
#'
softThresholdC <- function(z, g) {
    .Call('_hmlasso_softThresholdC', PACKAGE = 'hmlasso', z, g)
}

#' update rule function
#'
#' @param u u
#' @param l1 l1
#' @param l2 l2
#' @param v v
#' @return value
#' @keywords internal
#'
updateLassoC <- function(u, l1, l2, v) {
    .Call('_hmlasso_updateLassoC', PACKAGE = 'hmlasso', u, l1, l2, v)
}

#' Optimize a linear regression model by coordinate descent algorithm using a covariance matrix
#'
#' @param Gamma covariance matrix of explanatory variables
#' @param gamma covariance vector of explanatory and objective variables
#' @param lambda lambda sequence
#' @param warm warm start direction: "lambda" (default) or "delta"
#' @param delta ratio of regularization between l1 and exclusive penalty terms
#' @param R matrix using exclusive penalty term
#' @param maxit max iteration
#' @param eps convergence threshold for optimization
#' @param init_beta initial values of beta
#' @param strong whether use strong screening or not
#' @return standardized beta
#' @keywords internal
#' @export
covCdaC <- function(Gamma, gamma, lambda, R, init_beta, delta = 0, maxit = 1e+4, eps = 1e-04, warm = "lambda", strong = TRUE) {
    .Call('_hmlasso_covCdaC', PACKAGE = 'hmlasso', Gamma, gamma, lambda, R, init_beta, delta, maxit, eps, warm, strong)
}

