% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_cat_single_2018-02-05.R
\name{imp_cat_single}
\alias{imp_cat_single}
\title{The function to impute unordered categorical variables}
\usage{
imp_cat_single(y_imp, X_imp, pvalue = 0.2, rounding_degrees = c(1, 10, 100,
  1000))
}
\arguments{
\item{y_imp}{A Vector with the variable to impute.}

\item{X_imp}{A data.frame with the fixed effects variables.}

\item{pvalue}{A numeric between 0 and 1 denoting the threshold of p-values a variable in the imputation
model should not exceed. If they do, they are excluded from the imputation model.}

\item{rounding_degrees}{A numeric vector with the presumed rounding degrees.}
}
\value{
A n x 1 data.frame with the original and imputed values as a factor.
}
\description{
The function uses regression trees for imputation implemented in \code{mice}.
The principle is the following:
For each observation it is calculated at which leave it would end.
Then one (randomly selected) observation of the other observations found on this leave
functions as a donor.
}
