context("random_intercept_check")
library(testthat)
library(hmi)

#test_check("hmi")

test_that("correct random intercept variables are detected", {
  expect_false(random_intercept_check(y ~ .))
  expect_false(random_intercept_check(y ~ 0 + .))
  expect_false(random_intercept_check(y ~ -1 + .))
  expect_false(random_intercept_check(y ~ x + .))
  expect_false(random_intercept_check(y ~ 0 + x + .))
  expect_false(random_intercept_check(y ~ -1 + x + .))
  expect_false(random_intercept_check(y ~ x))
  expect_false(random_intercept_check(y ~ 0 + x))
  expect_false(random_intercept_check(y ~ -1 + x))
  expect_true(random_intercept_check(y ~ x + (1|id)))
  expect_true(random_intercept_check(y ~ x + (x|id)))
  expect_true(random_intercept_check(y ~ x + (1+x|id)))
  expect_false(random_intercept_check(y ~ x + (0|id)))
  expect_false(random_intercept_check(y ~ x + (0+x|id)))
  expect_false(random_intercept_check(y ~ x + (-1|id)))
  expect_false(random_intercept_check(y ~ x + (-1+x|id)))
})
