% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_actives}
\alias{plot_actives}
\title{Active variable plotting}
\usage{
plot_actives(ems, output_names = NULL, input_names = NULL)
}
\arguments{
\item{ems}{The list of emulators to consider}

\item{output_names}{The names of the outputs to include in the plot, if not all}

\item{input_names}{The names of the inputs to include in the plot, if not all}
}
\value{
A ggplot object corresponding to the plot
}
\description{
For a set of emulators, demonstrate which variables are active.
}
\details{
Each emulator has a list of `active' variables; those which contribute in an appreciable way
to its regression surface. It can be instructive to examine the differences in active variables
for a give collection of emulators. The plot here produces an nxp grid for n emulators in p
inputs; a square is blacked out if that variable does not contribute to that output.

Both the outputs and inputs can be restricted to collections of interest, if desired, with the
optional \code{output_names} and \code{input_names} parameters.
}
\examples{
 plot_actives(SIREmulators$ems)
 # Remove the nR output and aIR input from the plot
 plot_actives(SIREmulators$ems, c('nS', 'nI'), c('aSI', 'aSR'))
 # Note that we can equally restrict the emulator list...
 plot_actives(SIREmulators$ems[c('nS', 'nI')], input_names = c('aSI', 'aSR'))
}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{hit_by_wave}()},
\code{\link{output_plot}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
