% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiwaveplot.R
\name{hit_by_wave}
\alias{hit_by_wave}
\title{Output Hit Summary}
\usage{
hit_by_wave(
  waves,
  targets,
  input_names,
  measure = "mean",
  plt = FALSE,
  as.per = TRUE,
  grid.plot = TRUE
)
}
\arguments{
\item{waves}{The collection of waves, as a list of data.frames}

\item{targets}{The output targets}

\item{input_names}{The names of the input parameters}

\item{measure}{If stochastic, the measure to use to compare (see description)}

\item{plt}{If TRUE, results are plotted; else a data.frame is returned}

\item{as.per}{Should the data be percentages, or raw numbers?}

\item{grid.plot}{If \code{plt = TRUE}, determines the type of plot.}
}
\value{
Either a data.frame of results or a ggplot object plot
}
\description{
Provides a summary of numbers of points that hit n outputs
}
\details{
Given a collection of wave points and the targets used in history matching,
it might be informative to consider the proportion of points whose model
output matches a given number of targets. This function provides by-wave
information about how many parameter sets are matches to 0,1,2,...,n outputs.

The results of the analysis can be presented as a \code{data.frame} object
where each row is a wave and each column a number of outputs; if \code{plt = TRUE}
the results are instead presented visually, as a grid coloured by proportion of
total points (if \code{grid.plot = TRUE}, the default) or as a series of discrete
density lines, one per wave. The \code{as.per} argument determines whether the
output values are raw or if they are calculated percentages of the total number
of parameter sets for a given wave.

When the data arise from a stochastic model, and therefore parameter sets have
multiple realisations, there are multiple ways to analyze the data (determined
by \code{measure}). The options are "mean" to compare the means of realisations
to the outputs; "real" to compare all individual realisations; and "stoch" to
consider an output matched to if the mean lies within 3 standard deviations of
the output, where the standard deviation is calculated over the realisations.
}
\examples{
 # Default Usage
 hit_by_wave(SIRMultiWaveData, SIREmulators$targets, c('aSI', 'aIR', 'aSR'))
 # Plotting - line plot or raw figures
 hit_by_wave(SIRMultiWaveData, SIREmulators$targets, c('aSI', 'aIR', 'aSR'),
  plt = TRUE, as.per = FALSE, grid.plot = FALSE)
}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
