% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eplet-MHC-II.R
\name{CalEpletMHCII}
\alias{CalEpletMHCII}
\title{Calculate class II HLA eplet mismatch.}
\usage{
CalEpletMHCII(dat_in, ver = 2)
}
\arguments{
\item{dat_in}{A dataframe of recipient and donor's high resolution MHC II data. Each recipient and donor pair are linked by are the “pair_id” column and differentiated by the “subject_type” column.}

\item{ver}{Version number of HLAMatchMaker based eplet reference table to use.}
}
\value{
A list of data tables.
- `single_detail`: single molecule class II MHC eplet mismatch table, including mismatched eplet names and the count of eplets mismatched at each allele.
- `overall_count`: original input data appended with total count of mismatched eplets.
- `dqdr_risk`: DR DQ risk score.
}
\description{
Use high resolution HLA(Human Leukocyte Antigen) class II data to calculate class II eplet mismatch for a population of donors and recipients. Mismatch is calculated using logic from 'HLAMatchMaker', developed by Rene Dusquesnoy. Current reference tables supported are 'HLAMatchMaker' v2 and v3. Note: interlocus info only available in v3 reference tables.
}
\examples{
dat <- read.csv(system.file("extdata/example","MHC_II_test.csv",package="hlaR"),sep=",",header=TRUE)
re <- CalEpletMHCII(dat, ver = 2)
}
