% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_hindex.R
\name{simulate_hindex}
\alias{simulate_hindex}
\title{Simulate h-index and h-alpha values}
\usage{
simulate_hindex(runs = 1, n = 100, periods = 20,
  distr_initial_papers = "poisson", dpapers_pois_lambda = 2,
  dpapers_nbinom_dispersion = 1.1, dpapers_nbinom_mean = 2,
  distr_citations = "poisson", dcitations_speed = 2,
  dcitations_peak = 3, dcitations_mean = 2,
  dcitations_dispersion = 1.1, coauthors = 5,
  strategic_teams = FALSE, diligence_share = 1, diligence_corr = 0,
  selfcitations = FALSE, update_alpha_authors = FALSE, boost = FALSE,
  boost_size = 0.1, alpha_share = 0.33)
}
\arguments{
\item{runs}{Number of times the simulation is repeated.}

\item{n}{Number of agents acting in each simulation.}

\item{periods}{Number of periods the agents collaborate across in each period.}

\item{distr_initial_papers}{Distribution of the papers the scientists have
already published at the start of the simulation. Currently, the poisson
distribution ("poisson") and the negative binomial distribution ("nbinomial")
are supported.}

\item{dpapers_pois_lambda}{The distribution parameter for a poisson
distribution of initial papers.}

\item{dpapers_nbinom_dispersion}{Dispersion parameter of a negative binomial
distribution of initial papers.}

\item{dpapers_nbinom_mean}{Expected value of a negative binomial
distribution of initial papers.}

\item{distr_citations}{Distribution of citations the papers get. The expected
value of this distribution follows a log-logistic function of time.
Currently, the poisson distribution ("poisson") and the negative binomial
distribution ("nbinomial") are supported.}

\item{dcitations_speed}{The steepness (shape parameter) of the log-logistic
time function of the expected citation values.}

\item{dcitations_peak}{The period after publishing when the expected value
of the citation distribution reaches its maximum.}

\item{dcitations_mean}{The maximum expected value of the citation
distribution (at period dcitations_peak after publishing, the citation
distribution has dcitations_mean).}

\item{dcitations_dispersion}{For a negative binomial citation distribution,
dcitations_dispersion is a factor by which the variance exceeds the expected
value.}

\item{coauthors}{Average number of coauthors publishing papers.}

\item{strategic_teams}{If this parameter is set to TRUE, agents with high
h-index avoid co-authorships with agents who have equal or higher h-index
values (they strategically select co-authors to improve their h-alpha index).
This is implemented by assigning the agents with the highest h-index values
to separate teams and randomly assigning the other agents to the teams.
Otherwise, the collaborating agents are assigned to co-authorships at random.}

\item{diligence_share}{The share of agents publishing in each period.}

\item{diligence_corr}{The correlation between the initial h-index value and
the probability to publish in a given period. This parameter only has an
effect if diligence_share < 1.}

\item{selfcitations}{If this parameter is set to TRUE, a paper gets one
additional citation if at least one of its authors has a h-index value
that exceeds the number of previous citations of the paper by one or two.
This reflects agents strategically citing their own papers with citations
just below their h-index to accelerate the growth of their h-index.}

\item{update_alpha_authors}{If this parameter is set to TRUE, the alpha
author of newly written papers is determined every period based on the
current h-index values of its authors. Without this option, the alpha
author is determined when the paper is written and held constant from then on.}

\item{boost}{If this parameter is set to TRUE, papers of agents with a higher
h-index are cited more frequently than papers of agents with lower h-index.
For each team, this effect is based on the team's co-author with the
highest h-index within this team.}

\item{boost_size}{Magnitude of the boost effect. For every additional h point
of a paper's co-author who has the highest h-index among all of the paper's
co-authors, citations of the paper are increased by boost_size, rounded to the next
integer.}

\item{alpha_share}{The share of previously published papers where the
corresponding agent is alpha author.}
}
\value{
For each run, the h-index values and the h-alpha values for each
period are stored in a list of lists.
}
\description{
Simulate the effect of publishing, being cited, and (strategic)
collaborating on the development of h-index and h-alpha values for a
specified set of agents.
}
\examples{
set.seed(123)
simdata <- simulate_hindex(runs = 2, n = 20, periods = 3)
plot_hsim(simdata, plot_hindex = TRUE)
}
