% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tss.R
\name{tss}
\alias{tss}
\title{Total Sum Scaling normalisation}
\usage{
tss(abund)
}
\arguments{
\item{abund}{A vector or a matrix/data.frame indicating the relative abundances of one or multiple samples, respectively. If a matrix/data.frame is provided, columns must refer to samples and rows to OTUs.}
}
\value{
Normalised vector or matrix.
}
\description{
Normalise a vector or count matrix to the range of 0-1.
}
\details{
Total Sum Scaling normalisation
}
\examples{
data(bat.diet.otutable)
tss(bat.diet.otutable)
bat.diet.sample <- bat.diet.otutable[,1]
tss(bat.diet.sample)
}
\seealso{
\code{\link{hill_div}}, \code{\link{index_div}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{Hill}
\keyword{normalisation}
