% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_dis.R
\name{pair_dis}
\alias{pair_dis}
\title{Pairwise dissimilarity}
\usage{
pair_dis(countable, qvalue, tree, hierarchy, level, metric)
}
\arguments{
\item{countable}{A matrix indicating the relative abundances of multiple samples. Columns should be samples and rows OTUs.}

\item{qvalue}{A positive integer or decimal number (>=0), usually between 0 and 3.}

\item{tree}{A phylogenetic tree of class 'phylo'. The tip labels must match the row names in the OTU table. Use the function match_data() if the OTU names do not match.}

\item{hierarchy}{A matrix indicating the relation between samples (first column) and groups.}

\item{level}{If '1' dissimilarities are computed across samples, while if '2' dissimilarities are computed across groups, as specified by the hierarchy table. level=1.}

\item{metric}{A vector containing any combination of "C", "U", "V" or "S". If not provided, all metrics will be computed. metric="U", metric=c("U","S").}
}
\value{
A list of matrices containing pairwise beta diversities and dissimilarity metrics.
}
\description{
Computation of pairwise dissimilarities based on Hill numbers diversity partitioning
}
\details{
Pairwise dissimilarity
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
data(bat.diet.hierarchy)
pair_dis(bat.diet.otutable,qvalue=1)
\donttest{
pair_dis(bat.diet.otutable,qvalue=1,tree=bat.diet.tree,metric="V")
}
pair_dis(bat.diet.otutable,qvalue=0,hierarchy=bat.diet.hierarchy,level="2")
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Chao, A., Chiu, C.H., & Hsieh, T. C. (2012). Proposing a resolution to debates on diversity partitioning. Ecology, 93, 2037-2051.\cr\cr
Jost, L. (2007). Partitioning diversity into independent alpha and beta components. Ecology, 88, 2427-2439.
}
\seealso{
\code{\link{hill_div}}, \code{\link{div_part}}, \code{\link{beta_dis}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{beta}
\keyword{diversity}
\keyword{hill}
\keyword{numbers}
\keyword{partitioning}
