% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_dis.R
\name{beta_dis}
\alias{beta_dis}
\title{Beta dissimilarity}
\usage{
beta_dis(beta, qvalue, N, metric, type)
}
\arguments{
\item{beta}{A numeric beta diversity value or an object outputted by function div_part() (which contains all the information to compute (dis)similarities).}

\item{qvalue}{A positive number, usually between 0 and 5, but most commonly 0, 1 or 2. It can be an integer or contain decimals.}

\item{N}{An integer indicating sample size, the number of sampling units to be used to compute the (dis)similarity measures. The argument is ovewritten if a 'div_part' object is used.}

\item{metric}{A vector containing "C", "U", "V" or "S". C: Sørensen-type overlap or complement. U: Jaccard-type overlap or complement. V: Sørensen-type turnover or complement. S: Jaccard-type turnover or complement. See hilldiv wiki for further information.}

\item{type}{A character object containing either "similarity" or "dissimilarity". If 'similarity' is used, similarity metrics (0: completely different composition - 1: identical composition) are returned. If 'dissimilarity' is used, dissimilarity metrics (0: identical composition - 1:completely different composition) are returned.}
}
\description{
Compute dissimilarity or similarity values based on beta diversities (neutral or phylogenetic) and sample size.
}
\details{
(Dis)similarity computation from beta diversities based on Hill numbers
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
#Manually indicating beta diversity, order of diversity and sample size
beta_dis(beta=4.5,qvalue=1,N=8)
beta_dis(beta=4.5,qvalue=1,N=8,metric="C",type="similarity")
#Using an object created with the function div_part()
divpartobject <- div_part(bat.diet.otutable,qvalue=0,tree=bat.diet.tree)
beta_dis(divpartobject)
beta_dis(divpartobject,metric="S",type="similarity")
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Chao, A., Chiu, C.H., & Hsieh, T. C. (2012). Proposing a resolution to debates on diversity partitioning. Ecology, 93, 2037-2051.\cr\cr
Jost, L. (2007). Partitioning diversity into independent alpha and beta components. Ecology, 88, 2427-2439.
}
\seealso{
\code{\link{div_part}}, \code{\link{gamma_div}}, \code{\link{pair_dis}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{alpha}
\keyword{beta}
\keyword{dissimilarity}
\keyword{gamma}
\keyword{hill}
\keyword{partitioning}
\keyword{similarity}
