% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/det_hrz_eval_ar.R
\name{det_hrz_eval_ar}
\alias{det_hrz_eval_ar}
\title{Determination of high-risk zone on smaller area of interest (evaluation area) than observation area.}
\usage{
det_hrz_eval_ar(
  ppdata,
  eval_ar,
  criterion = c("indirect", "direct"),
  cutoff,
  intens = NULL,
  nxprob = 0.1,
  covmatrix = NULL
)
}
\arguments{
\item{ppdata}{Observed spatial point process of class ppp in the observation area.}

\item{eval_ar}{area of interest specified via an object of class owin}

\item{criterion}{criterion to limit the high-risk zone, can be \code{"indirect"} (failure probability 
alpha) or \code{"direct"} (threshold, i.e. maximum intensity of unexploded bombs outside hrz)}

\item{cutoff}{Value of criterion (alpha or threshold)}

\item{intens}{(optional) estimated intensity of the observed process (object of class "im") in (bigger) 
observation area, if not given, it will be estimated using \code{\link[spatstat.explore]{density.ppp}}.}

\item{nxprob}{Probability of having unobserved events.
Default value is 0.1.}

\item{covmatrix}{(optional) Covariance matrix of the kernel of a normal distribution, only needed for 
\code{type="intens"} if no intensity is given. If not given, it will be estimated
using \code{\link[ks]{Hscv}}.}
}
\value{
An object of class "\code{highriskzone}"
}
\description{
\code{det_hrz_eval_ar} determines intensity based highriskzones if bomb crater observations are available
for a bigger area than the area of main interest (evaluation area).
All observations are used for intensity estimation, the highriskzone is however constructed only in the
evaluation area. Either based on specifying a failure probability alpha that indicates the probability of 
unobserved bombs outside the highriskzone but inside the evaluation area of interest (and not in the 
overall observation area) (criterion = "indirect"), or by specifying the threshold (maximum intensity of non-
exploded bombs outside the) highriskzone directly and intersecting the resulting hrz with the 
evaluation area (criterion = "direct").
}
\examples{
set.seed(12412)
spatstat.geom::spatstat.options(npixel=300)
data(craterB)
# reduce number of observations for faster computation
thin.craterB <- craterB[sample(1:craterB$n, 40)]
# define evaluation area of interest
eval.ar <- spatstat.geom::owin(xrange = c(0, 1900), yrange = c(0, 3400), 
               poly = matrix(c(250,250, 1200,1000,250,1000), byrow = TRUE, ncol = 2))

hrzi1 <- det_hrz_eval_ar(thin.craterB, eval_ar = eval.ar, criterion = "direct",
                        cutoff = 3e-6, nxprob = .2)

plot(hrzi1)
plot(thin.craterB, add = TRUE)
plot(eval.ar, add = TRUE)
plot(craterB$window, add = TRUE)
}
