% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api.R
\name{hc_navigator}
\alias{hc_navigator}
\title{Navigator options for highcharter objects}
\usage{
hc_navigator(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{https://api.highcharts.com/highstock/navigator}.}
}
\description{
The navigator is a small series below the main series, displaying
a view of the entire data set. It provides tools to zoom in and
out on parts of the data as well as panning across the dataset.
}
\examples{

highchart(type = "stock") \%>\% 
  hc_add_series(AirPassengers) \%>\% 
  hc_rangeSelector(selected = 4) \%>\% 
  hc_navigator(
    outlineColor = "gray",
    outlineWidth = 2,
    series = list(
      color = "red",
      lineWidth = 2,
      type = "areaspline", # you can change the type
      fillColor = "rgba(255, 0, 0, 0.2)"
    ),
    handles = list(
      backgroundColor = "yellow",
      borderColor = "red"
    )
  )

}
