% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhsmmdata.R
\name{hhsmmdata}
\alias{hhsmmdata}
\title{convert to hhsmm data}
\usage{
hhsmmdata(x, N = NULL)
}
\arguments{
\item{x}{a matrix of data}

\item{N}{a vector of sequence lengths. If NULL then \code{N = nrow(x)}}
}
\value{
a data list of class \code{"hhsmmdata"} containing \code{x} and \code{N}
}
\description{
Converts a matrix of data and its associated vector of sequence lengths
to a data list of class \code{"hhsmmdata"}
}
\examples{
x = sapply(c(1,2), function(i) rnorm(100,i,i/2))
N = c(10, 15, 50, 25)
data = hhsmmdata(x,N)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat, \email{aftbayat@gmail.com}
}
