% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetmeta.R
\name{hetmeta}
\alias{hetmeta}
\title{Deriving Measures Of Heterogeneity}
\usage{
hetmeta(model)
}
\arguments{
\item{model}{an object of class "\code{\link{rma.uni}}".}
}
\value{
The \code{hetmeta} function returns an object of class "\code{hetmeta}" as described in \code{\link{hetmetaObject}}.
}
\description{
The "\code{hetmeta}" implements the most common measures of heterogenity in meta-analysis.
}
\details{
The "\code{hetmeta}" function calculates estimates for several heterogeneity measures in
meta-analysis based on a meta-analytic model of class \code{\link{rma.uni}}
(see \code{\link{metafor-package}} for more details).

Specifically, the measures derived in the function are the $R_b$, $I^2$, and $R_I$.
To complement those measures, the Dersimonian-Laird $Q$ test is presented, together with
the coefficient of variation of the pooled estimate $CV_b$, coefficient of variation
of the within-study variances, and the typical within-variance terms as
defined in the $I^2$ and $R_I$. See references for more details.
}
\examples{
## load data
dat <- get(data(dat.gibson2002))

## random-effects model analysis of the standardized mean differences
dat <- escalc(measure = "SMD", m1i = m1i, sd1i = sd1i, n1i = n1i, m2i = m2i,
              sd2i = sd2i, n2i = n2i, data = dat)
res <- rma(yi, vi, data = dat, method = "REML")

## heterogeneity measures
hetmeta(res)


## load BCG vaccine data
data(dat.bcg)

## random-effects model of log relative risks
dat <- escalc(measure="RR", ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat.bcg)
res <- rma(yi, vi, data=dat)

## heterogeneity measures
hetmeta(res)

}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
\references{
Crippa A, Khudyakov P, Wang M, Orsini N, Spiegelman D. A new measure of between-studies
heterogeneity in meta-analysis. 2016. \emph{Stat. Med.} In Press.

Takkouche B, Khudyakov P, Costa-Bouzas J, Spiegelman D. Confidence Intervals for Heterogeneity Measures in Meta-analysis. \emph{Am. J. Epidemiol.} 2013:kwt060.

Higgins JPT, Thompson SG. Quantifying heterogeneity in a meta-analysis. \emph{Stat. Med.} 2002; 21(11):1539-1558.

Takkouche B, Cadarso-Suarez C, Spiegelman D. Evaluation of old and new tests of heterogeneity in epidemiologic meta-analysis. Am. J. Epi- demiol. 1999; 150(2):206-215.
}
\seealso{
\code{\link{hetmeta-package}}, \code{\link{metafor}}
}

