% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetGP.R
\name{scores}
\alias{scores}
\title{Score and RMSE function
To asses the performance of the prediction, this function computes the root mean squared error and proper score function (also known as negative log-probability density).}
\usage{
scores(model, Xtest, Ztest, return.rmse = FALSE)
}
\arguments{
\item{model}{\code{homGP} or \code{hetGP} model, including inverse matrices}

\item{Xtest}{matrix of new design locations}

\item{Ztest}{corresponding vector of observations, or alternatively, 
a matrix of size [nrow(Xtest) x number of replicates], a list of size nrow(Xtest) with a least one value per element}

\item{return.rmse}{if \code{TRUE}, return the root mean squared error}
}
\description{
Score and RMSE function
To asses the performance of the prediction, this function computes the root mean squared error and proper score function (also known as negative log-probability density).
}
\references{
T. Gneiting, and A. Raftery (2007). Strictly Proper Scoring Rules, Prediction, and Estimation, Journal of the American Statistical Association, 102(477), 359-378.
}
