% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cea.R
\name{icer}
\alias{icer}
\alias{format.icer}
\title{Incremental cost-effectiveness ratio}
\usage{
icer(x, prob = 0.95, k = 50000, labels = NULL, ...)

\method{format}{icer}(
  x,
  digits_qalys = 2,
  digits_costs = 0,
  pivot_from = "strategy",
  drop_grp = TRUE,
  pretty_names = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{cea_pw} returned by \code{\link[=cea_pw]{cea_pw()}}.}

\item{prob}{A numeric scalar in the interval \verb{(0,1)} giving the confidence interval.
Default is 0.95 for a 95 percent interval.}

\item{k}{Willingness to pay per quality-adjusted life-year.}

\item{labels}{A list of named vectors containing the values and labels of
variables. The elements of each vector are the values of a variable and the
names are the labels. The names of the list are the names of the variables.
See the output returned by \code{\link[=get_labels]{get_labels()}} for an example.}

\item{...}{Further arguments passed to and from methods. Currently unused.}

\item{digits_qalys}{Number of digits to use to report QALYs.}

\item{digits_costs}{Number of digits to use to report costs.}

\item{pivot_from}{Character vector denoting a column or columns used to
"widen" the data. Should either be \code{"strategy"}, \code{"grp"}, \code{"outcome"},
or some combination of the three. There will be one column for each value of
the variables in \code{pivot_from}. Default is to widen so there is a column for each treatment
strategy. Set to \code{NULL} if you do not want to widen the table.}

\item{drop_grp}{If \code{TRUE}, then the group column will be removed if there is only
one subgroup; other it will be kept. If \code{FALSE}, then the \code{grp} column is never
removed.}

\item{pretty_names}{Logical. If \code{TRUE}, then the columns \code{strategy}, \code{grp},
\code{outcome}, and \code{value} are renamed (if they exist) to \code{Strategy},
\code{Group}, \code{Outcome}, and \code{Value}.}
}
\value{
\code{icer()} returns an object of class \code{icer} that is a tidy
\code{data.table} with the following columns:
\describe{
\item{strategy}{The treatment strategy.}
\item{grp}{The subgroup.}
\item{outcome}{The outcome metric.}
\item{estimate}{The point estimate computed as the average across the PSA samples.}
\item{lower}{The lower limit of the confidence interval.}
\item{upper}{The upper limit of the confidence interval.}
}

\code{format.icer()} formats the table according to the arguments passed.
}
\description{
Generate a tidy table of incremental cost-effectiveness ratios (ICERs) given output from
\code{\link[=cea_pw]{cea_pw()}} with \code{icer()} and format for pretty printing with \code{format.icer()}.
}
\details{
Note that \code{icer()} will report negative ICERs; however, \code{format()} will
correctly note whether a treatment strategy is dominated by or dominates the
reference treatment.
}
\seealso{
\code{\link[=cea_pw]{cea_pw()}}
}
