% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params_joined_surv_list}
\alias{params_joined_surv_list}
\title{Parameters of joined lists of survival models}
\usage{
params_joined_surv_list(..., times)
}
\arguments{
\item{...}{Objects of class \code{\link{params_surv_list}}, which can be named.}

\item{times}{A list of sorted numeric vectors, with the length of each list element equal
to the number of sets of models.}
}
\value{
An object of class "params_joined_surv_list", which is a list containing two elements:
\describe{
\item{models}{A list of \code{\link{params_surv_list}}, each containing code{\link{params_surv}} 
objects to be joined.}
\item{times}{Equivalent to the argument \code{times}.}
}
}
\description{
Create a list containing the parameters of multiple sets of survival models, each joined
at specified time points. See \code{\link{joined}} for more details.
}
\examples{
library("flexsurv")
fit_exp <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                                 data = ovarian, dist = "exp")
fit_wei <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                                 data = ovarian, dist = "weibull")
fit_lnorm <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                                  data = ovarian, dist = "lognormal")

params_exp <- create_params(fit_exp, n = 2)
params_wei <- create_params(fit_wei, n = 2)
params_lnorm <- create_params(fit_lnorm, n = 2)

params_list1 <- params_surv_list(params_exp, params_wei)
params_list2 <- params_surv_list(params_exp, params_lnorm)
params_joined <- params_joined_surv_list(model1 = params_list1,
                                         model2 = params_list2,
                                         times = list(3, 5))
print(params_joined)
}
