% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{mom_gamma}
\alias{mom_gamma}
\title{Method of moments for gamma distribution}
\usage{
mom_gamma(mean, sd, scale = TRUE)
}
\arguments{
\item{mean}{Mean of the random variable.}

\item{sd}{Standard deviation of the random variable.}

\item{scale}{Logical. If TRUE (default), then the scale parameter is returned; otherwise,
the rate parameter is returned.}
}
\value{
If \code{scale = TRUE}, then a list containing the parameters \code{shape} and \code{scale}; otherwise,
 if \code{scale = FALSE}, then a list containing the parameters \code{shape} and \code{rate}.
}
\description{
Compute the shape and scale (or rate) parameters of the gamma distribution
using method of moments for the random variable of interest.
}
\details{
If \eqn{\mu} is the mean and 
\eqn{\sigma} is the standard deviation of the random variable, then the method
of moments estimates of the parameters \code{shape} = \eqn{\alpha > 0} and
\code{scale} = \eqn{\theta > 0} are:
\deqn{\theta = \frac{\sigma^2}{\mu}}
and
\deqn{\alpha = \frac{\mu}{\theta}} 

The inverse of the scale parameter, \eqn{\beta = 1/\theta}, is the rate parameter.
}
\examples{
mom_gamma(mean = 10000, sd = 2000)
# The function is vectorized.
mom_gamma(mean = c(8000, 10000), sd = c(1500, 2000))

}
