% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.sts.R
\name{prepare.sts}
\alias{prepare.sts}
\title{Prepare \code{starray} for sandwich smooth}
\usage{
\method{prepare}{sts}(
  data,
  coords,
  times,
  rs,
  bs,
  m = 2,
  sparse = TRUE,
  spdiffpen = TRUE,
  ...
)
}
\arguments{
\item{data}{An \code{\link{starray}}}

\item{coords}{A two-dimensional matrix-like object with
non-NULL dimensions.}

\item{times}{The vector of times at which the data were observed.}

\item{rs}{A \code{hero_radspline} produced by the \code{\link{radspline}} or
\code{\link{connect}} functions.}

\item{bs}{A \code{hero_bspline} produced by the \code{\link{bspline}} function.}

\item{m}{A positive integer indicating order of the difference penalty.}

\item{sparse}{A logical value indicating if the result
should be a sparse version of the
\code{\link[Matrix]{Matrix-class}}.}

\item{spdiffpen}{A logical value indicating whether
\code{\link{spdiffpen}} should be used to compute the
difference penalty.  The default is \code{FALSE}.}

\item{...}{Not currently implemented.}
}
\value{
A \code{prepared_sts} object.
}
\description{
\code{prepare.starray} prepares a spatio-temporal
array for the sandwich smooth.
}
\examples{
# construct basis functions
border = border.grid(lon, lat)
rs = radspline(nknots = 36, poverlap = 3,
               border = border, longlat = TRUE)
bs = bspline(c(1, 30), nbasis = 6)
splines = list(rs, bs)
data = as.sts(tasmax)
p = prepare(data, coords = cbind(c(lon), c(lat)),
            times = 1:30, rs = rs, bs = bs)
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>
}
\seealso{
\code{\link{bspline}}, \code{\link{radspline}}
}
\author{
Joshua French.  Based off code by Luo Xiao (see
  References).
}
