% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.evalargs.R
\name{default.evalargs}
\alias{default.evalargs}
\title{Construct default \code{evalargs}}
\usage{
default.evalargs(data)
}
\arguments{
\item{data}{A matrix or array-like object}
}
\value{
A list of equidistance sequences between 0 and 1
}
\description{
Create a default \code{evalargs} object based on
\code{data}.  This is just a list of sequences.
If \code{ni = dim(data)[i]}, then the sequence for
dimension i is \code{seq(0, 1, len = ni)}.
}
\examples{
a = array(rnorm(10 * 11 * 12), dim = 10:12)
default.evalargs(a)
}
\author{
Joshua French
}
